//Edsca Migraine version 0.5
//October 2001
//This file (and also Edsca Migraine.dll) may not be used in ANY capacity
//for the purpose or with the intention of making a profit,
//without prior written permission from the author:
//Edward Earl machine@emaajne.freeserve.co.uk

//DEVELOPERS: If you want to try to clean up this code, please feel free,
//but please mail me if you want to do anything with it (i.e. release it)

//Thanks: Cyanphase for his excellent effects tutorial;
//Rymix for invaluable advice;
//Oskari for Buzz ;)

#include "../mdk/mdk.h"

#include <windows.h>

#include <math.h>

#include <float.h>



#pragma optimize ("awy", on) 

float id = 1e-15;
float tiny = 1e-10;


CMachineParameter const paraIngain =

{

            pt_byte,                        // Parameter data type

            "Input gain",                        // Parameter name as its shown in the parameter 

                                                // window

            "Input amplitude",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x7F                        // the default slider value

};

CMachineParameter const paraInclip =

{

            pt_byte,                        // Parameter data type

            "In->Soft",                        // Parameter name as its shown in the parameter 

                                                // window

            "Input clipping: 0=hard, 1=soft",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            1,                        // Maximum value-0=soft, 1=hard, 2=none

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0                        // the default slider value

};



CMachineParameter const paraCheb2 =

{

            pt_byte,                        // Parameter data type

            "Cheb2 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T2",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb2Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb2 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T2",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraCheb3 =

{

            pt_byte,                        // Parameter data type

            "Cheb3 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T3",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb3Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb3 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T3",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraCheb4 =

{

            pt_byte,                        // Parameter data type

            "Cheb4 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T4",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb4Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb4 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T4",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraCheb5 =

{

            pt_byte,                        // Parameter data type

            "Cheb5 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T5",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb5Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb5 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T5",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraCheb6 =

{

            pt_byte,                        // Parameter data type

            "Cheb6 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T6",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb6Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb6 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T6",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};




CMachineParameter const paraCheb7 =

{

            pt_byte,                        // Parameter data type

            "Cheb7 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T7",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb7Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb7 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T7",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};




CMachineParameter const paraCheb8 =

{

            pt_byte,                        // Parameter data type

            "Cheb8 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Chebyshev Polynomial T8",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraCheb8Ret =

{

            pt_byte,                        // Parameter data type

            "Cheb8 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Chebyshev Polynomial T8",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};


CMachineParameter const paraLeg2 =

{

            pt_byte,                        // Parameter data type

            "Leg2 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P2",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg2Ret =

{

            pt_byte,                        // Parameter data type

            "Leg2 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P2",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraLeg3 =

{

            pt_byte,                        // Parameter data type

            "Leg3 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P3",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg3Ret =

{

            pt_byte,                        // Parameter data type

            "Leg3 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P3",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraLeg4 =

{

            pt_byte,                        // Parameter data type

            "Leg4 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P4",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg4Ret =

{

            pt_byte,                        // Parameter data type

            "Leg4 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P4",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraLeg5 =

{

            pt_byte,                        // Parameter data type

            "Leg5 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P5",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg5Ret =

{

            pt_byte,                        // Parameter data type

            "Leg5 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P5",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};





CMachineParameter const paraLeg6 =

{

            pt_byte,                        // Parameter data type

            "Leg6 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P6",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg6Ret =

{

            pt_byte,                        // Parameter data type

            "Leg6 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P6",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};




CMachineParameter const paraLeg7 =

{

            pt_byte,                        // Parameter data type

            "Leg7 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P7",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg7Ret =

{

            pt_byte,                        // Parameter data type

            "Leg7 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P7",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};




CMachineParameter const paraLeg8 =

{

            pt_byte,                        // Parameter data type

            "Leg8 Send",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amount sent to Legendre Polynomial P8",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x00                        // the default slider value

};

CMachineParameter const paraLeg8Ret =

{

            pt_byte,                        // Parameter data type

            "Leg8 Ret",                        // Parameter name as its shown in the parameter 

                                                // window

            "Return amount of Legendre Polynomial P8",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x0                        // the default slider value

};




CMachineParameter const paraDry =

{

            pt_byte,                        // Parameter data type

            "Dry Amp",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amplitude of Dry Signal",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x7F                        // the default slider value

};

CMachineParameter const paraWet =

{

            pt_byte,                        // Parameter data type

            "Wet Amp",                        // Parameter name as its shown in the parameter 

                                                // window

            "Amplitude of Wet Signal",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            0xFE,                        // Maximum value

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0x7F                        // the default slider value

};

CMachineParameter const paraOutclip =

{

            pt_byte,                        // Parameter data type

            "Out->Soft",                        // Parameter name as its shown in the parameter 

                                                // window

            "Output clipping: 0=hard, 1=soft",// Parameter description as its shown in the 

                                                // pattern view's statusbar

            0,                                    // Minimum value

            1,                        // Maximum value-0=soft, 1=hard, 2=none

            0xFF,                        // Novalue, this value means "nothing 

                                                // happened" in the mi::Tick procedure

            MPF_STATE,                        // Parameter options, MPF_STATE makes it 

                                                // appears as a slider

            0                        // the default slider value

};


CMachineParameter const *pParameters[] = {

            &paraIngain,

	&paraInclip,

	&paraCheb2,

	&paraCheb2Ret,

            &paraCheb3,

	&paraCheb3Ret,

            &paraCheb4,

	&paraCheb4Ret,

            &paraCheb5,

	&paraCheb5Ret,

            &paraCheb6,

	&paraCheb6Ret,

            &paraCheb7,

	&paraCheb7Ret,

            &paraCheb8,

	&paraCheb8Ret,

	&paraLeg2,

	&paraLeg2Ret,

            &paraLeg3,

	&paraLeg3Ret,

            &paraLeg4,

	&paraLeg4Ret,

            &paraLeg5,

	&paraLeg5Ret,

            &paraLeg6,

	&paraLeg6Ret,

            &paraLeg7,

	&paraLeg7Ret,

            &paraLeg8,

	&paraLeg8Ret,

&paraDry,

&paraWet,

&paraOutclip

};

CMachineAttribute const *pAttributes[] = { NULL };



#pragma pack(1)                        



class gvals 

{public: byte ingain; byte inclip; byte cheb2; byte cheb2ret; byte cheb3; byte cheb3ret; byte cheb4; byte cheb4ret; byte cheb5; byte cheb5ret; byte cheb6; byte cheb6ret; byte cheb7; byte cheb7ret; byte cheb8; byte cheb8ret; byte leg2; byte leg2ret; byte leg3; byte leg3ret; byte leg4; byte leg4ret; byte leg5; byte leg5ret; byte leg6; byte leg6ret; byte leg7; byte leg7ret; byte leg8; byte leg8ret; byte dry; byte wet; byte outclip;

 };



#pragma pack()



CMachineInfo const MacInfo = 

{

            MT_EFFECT,                        // Machine type

            MI_VERSION,                        // Machine interface version

            MIF_DOES_INPUT_MIXING,            // Machine flags

            0,                                    // min tracks

            0,                                    // max tracks

            33,                                    // numGlobalParameters

            0,                                    // numTrackParameters

            pParameters,            // pointer to parameter stuff

            0,                                    // numAttributes

            pAttributes,            // pointer to attribute stuff

            "Edsca Migraine",            // Full Machine Name

            "Migraine",                        // Short name

            "Edsca",            // Author name

            "&About..."                        // Right click menu commands

};





class miex : public CMDKMachineInterfaceEx { };



class mi : public CMDKMachineInterface

{

public:

            mi();

            virtual ~mi();

            virtual void Tick();

            virtual void MDKInit(CMachineDataInput * const pi);

            virtual bool MDKWork(float *psamples, int numsamples, int const mode);

            virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);

            virtual void Command(int const i);

            virtual void MDKSave(CMachineDataOutput * const po);

            virtual char const *DescribeValue(int const param, int const value);

            virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }

            virtual void OutputModeChanged(bool stereo) {}



public:

            miex ex;



public:

            float param_ingain;

		float param_cheb2, param_cheb3, param_cheb4, param_cheb5, param_cheb6;

            float param_cheb7, param_cheb8, param_dry;

		float param_cheb2ret, param_cheb3ret, param_cheb4ret, param_cheb5ret, param_cheb6ret;

		float param_cheb7ret, param_cheb8ret;

		float param_leg2, param_leg3, param_leg4, param_leg5, param_leg6;

		float param_leg7, param_leg8;

		float param_leg2ret, param_leg3ret, param_leg4ret, param_leg5ret;

		float param_leg6ret, param_leg7ret, param_leg8ret, param_wet;

		int param_inclip, param_outclip;

	float coefs[9][14]; //array of coefficients for waveshaping. 
				//Use like coefs[power of x][algorithm]
				//where algorithm is 0 = cheb2, 1 = cheb3,
				// ... 7 = leg2, 8 = leg3... 13 = leg8.

	float dcspeedL, dcposL, dcspeedR, dcposR;

	float temp;

            gvals gval;

};



mi::mi() {  GlobalVals = &gval; }

mi::~mi() { }



void mi::MDKInit(CMachineDataInput * const pi)

{

	int order, alg;
            SetOutputMode( true ); // No mono sounds
	param_cheb2 = param_cheb3 = param_cheb4 = param_cheb5 = param_cheb6 = param_cheb7 = param_cheb8 = 0.0f;
	param_cheb2ret = param_cheb3ret = param_cheb4ret = param_cheb5ret = param_cheb6ret = param_cheb7ret = param_cheb8ret = 0.0f;
	param_leg2 = param_leg3 = param_leg4 = param_leg5 = param_leg6 = param_leg7 = param_leg8 = 0.0f;
	param_leg2ret = param_leg3ret = param_leg4ret = param_leg5ret = param_leg6ret = param_leg7ret = param_leg8ret = 0.0f;

	param_inclip = param_outclip = 0;

	
for(order=0; order<9; order++){
	for(alg =0; alg<14; alg++){
		coefs[order][alg] = 0.0f;
	}
}

	dcspeedL = 0.0f;
	dcposL = 0.0f;
	dcspeedR = 0.0f;
	dcposR = 0.0f;

}



void mi::MDKSave(CMachineDataOutput * const po) { }



void mi::Tick() {



            if (gval.cheb2 != 0xFF) { 



                        param_cheb2 = ((float)gval.cheb2 / 254.0f); 

			coefs[2][0] = 2.0f * param_cheb2 * param_cheb2 * param_cheb2ret;

			coefs[0][0] = param_cheb2ret;



	};



if (gval.cheb3 != 0xFF) { 



                        param_cheb3 = ((float)gval.cheb3 / 254.0f); 

			coefs[1][1] = -3.0f * param_cheb3 * param_cheb3ret;

			coefs[3][1] = 4.0f * param_cheb3 * param_cheb3 * param_cheb3 * param_cheb3ret;

            };



if (gval.cheb4 != 0xFF) { 



                        param_cheb4 = ((float)gval.cheb4 / 254.0f); 

			temp = param_cheb4 * param_cheb4;

			coefs[0][2] = param_cheb4ret;

			coefs[2][2] = -8.0f * temp * param_cheb4ret;

			coefs[4][2] = 8.0f * temp * temp * param_cheb4ret;



            };



if (gval.cheb5 != 0xFF) { 



                        param_cheb5 = ((float)gval.cheb5 / 254.0f); 

			temp = param_cheb5 * param_cheb5;

			coefs[1][3] = 5.0f * param_cheb5 * param_cheb5ret;

			coefs[3][3] = -20.0f * temp * param_cheb5 * param_cheb5ret;

			coefs[5][3] = 16.0f * temp * temp * param_cheb5 * param_cheb5ret;



            };



if (gval.cheb6 != 0xFF) { 



                        param_cheb6 = ((float)gval.cheb6 / 254.0f); 

			temp = param_cheb6 * param_cheb6;

			coefs[0][4] = -1.0f * param_cheb6ret;

			coefs[2][4] = 18.0f * temp * param_cheb6ret;

			coefs[4][4] = -48.0f * temp * temp * param_cheb6ret;

			coefs[6][4] = 32.0f * temp * temp * temp * param_cheb6ret;



            };



if (gval.cheb7 != 0xFF) { 



                        param_cheb7 = ((float)gval.cheb7 / 254.0f); 

			temp = param_cheb7 * param_cheb7;

			coefs[1][5] = -7.0f * param_cheb7 * param_cheb7ret;

			coefs[3][5] = 56.0f * param_cheb7 * temp * param_cheb7ret;

			coefs[5][5] = -112.0f * param_cheb7 * temp * temp * param_cheb7ret;

			coefs[7][5] = 64.0f * param_cheb7 * temp * temp * temp * param_cheb7ret;



            };



if (gval.cheb8 != 0xFF) { 



                        param_cheb8 = ((float)gval.cheb8 / 254.0f); 

			temp = param_cheb8 * param_cheb8;

			coefs[0][6] = param_cheb8ret;

			coefs[2][6] = -32.0f * temp * param_cheb8ret;

			coefs[4][6] = 160.0f * temp * temp * param_cheb8ret;

			coefs[6][6] = -256.0f * temp * temp * temp * param_cheb8ret;

			coefs[8][6] = 128.0f * temp * temp * temp * temp * param_cheb8ret;



            };



if (gval.cheb2ret != 0xFF) { 



                        param_cheb2ret = ((float)gval.cheb2ret / 254.0f); 

			coefs[2][0] = 2.0f * param_cheb2 * param_cheb2 * param_cheb2ret;

			coefs[0][0] = param_cheb2ret;



            };



if (gval.cheb3ret != 0xFF) { 



                        param_cheb3ret = ((float)gval.cheb3ret / 254.0f); 

			param_cheb3 = ((float)gval.cheb3 / 127.0f) - 1.0f; 

			coefs[1][1] = -3.0f * param_cheb3 * param_cheb3ret;

			coefs[3][1] = 4.0f * param_cheb3 * param_cheb3 * param_cheb3 * param_cheb3ret;



            };



if (gval.cheb4ret != 0xFF) { 



                        param_cheb4ret = ((float)gval.cheb4ret / 254.0f); 

			temp = param_cheb4 * param_cheb4;

	coefs[0][2] = param_cheb4ret;

			coefs[2][2] = -8.0f * temp * param_cheb4ret;

			coefs[4][2] = 8.0f * temp * temp * param_cheb4ret;



            };



if (gval.cheb5ret != 0xFF) { 



                        param_cheb5 = ((float)gval.cheb5ret / 254.0f); 

			temp = param_cheb5 * param_cheb5;

			coefs[1][3] = 5.0f * param_cheb5 * param_cheb5ret;

			coefs[3][3] = -20.0f * temp * param_cheb5 * param_cheb5ret;

			coefs[5][3] = 16.0f * temp * temp * param_cheb5 * param_cheb5ret;



            };



if (gval.cheb6ret != 0xFF) { 



                        param_cheb6ret = ((float)gval.cheb6ret / 254.0f); 

			temp = param_cheb6 * param_cheb6;

			coefs[0][4] = -1.0f * param_cheb6ret;

			coefs[2][4] = 18.0f * temp * param_cheb6ret;

			coefs[4][4] = -48.0f * temp * temp * param_cheb6ret;

			coefs[6][4] = 32.0f * temp * temp * temp * param_cheb6ret;



            };



if (gval.cheb7ret != 0xFF) { 



                        param_cheb7ret = ((float)gval.cheb7ret / 254.0f); 

			temp = param_cheb7 * param_cheb7;

			coefs[1][5] = -7.0f * param_cheb7 * param_cheb7ret;

			coefs[3][5] = 56.0f * param_cheb7 * temp * param_cheb7ret;

			coefs[5][5] = -112.0f * param_cheb7 * temp * temp * param_cheb7ret;

			coefs[7][5] = 64.0f * param_cheb7 * temp * temp * temp * param_cheb7ret;



            };



if (gval.cheb8ret != 0xFF) { 



                        param_cheb8ret = ((float)gval.cheb8ret / 254.0f); 

			temp = param_cheb8 * param_cheb8;

			coefs[0][6] = param_cheb8ret;

			coefs[2][6] = -32.0f * temp * param_cheb8ret;

			coefs[4][6] = 160.0f * temp * temp * param_cheb8ret;

			coefs[6][6] = -256.0f * temp * temp * temp * param_cheb8ret;

			coefs[8][6] = 128.0f * temp * temp * temp * temp * param_cheb8ret;



            };



if (gval.leg2 != 0xFF) { 



                        param_leg2 = ((float)gval.leg2 / 254.0f); 

			coefs[0][7] = -0.5f * param_leg2ret;

			coefs[2][7] = 1.5f * param_leg2 * param_leg2 * param_leg2ret;



            };



if (gval.leg3 != 0xFF) { 



                        param_leg3 = ((float)gval.leg3 / 254.0f); 

			coefs[1][8] = -3.0f * param_leg3 * param_leg3ret;

			coefs[3][8] = 2.5f * param_leg3 * param_leg3 * param_leg3 * param_leg3ret;



            };



if (gval.leg4 != 0xFF) { 



                        param_leg4 = ((float)gval.leg4 / 254.0f); 

			temp = param_leg4 * param_leg4;

			coefs[0][9] = 0.375f * param_leg4ret;

			coefs[2][9] = -3.75f * temp * param_leg4ret;

			coefs[4][9] = 4.375f * temp * temp * param_leg4ret;



            };



if (gval.leg5 != 0xFF) { 



                        param_leg5 = ((float)gval.leg5 / 254.0f); 

			temp = param_leg5 * param_leg5;

			coefs[1][10] = 1.875f * param_leg5 * param_leg5ret;

			coefs[3][10] = -8.75f * temp * param_leg5 * param_leg5ret;

			coefs[5][10] = 7.875f * temp * temp * param_leg5 * param_leg5ret;



            };



if (gval.leg6 != 0xFF) { 



                        param_leg6 = ((float)gval.leg6 / 254.0f); 

			temp = param_leg6 * param_leg6;

			coefs[0][11] = 0.3125f * param_leg6ret;

			coefs[2][11] = 6.5625f * temp * param_leg6ret;

			coefs[4][11] = -19.6875f * temp * temp * param_leg6ret;

			coefs[6][11] = 14.4375f * temp * temp * temp * param_leg6ret;



            };



if (gval.leg7 != 0xFF) { 



                        param_leg7 = ((float)gval.leg7 / 254.0f); 

			temp = param_leg7 * param_leg7;

			coefs[0][12] = 15.3125f * param_leg7ret;

			coefs[3][12] = 127.96875f * temp * param_leg7 * param_leg7ret;

			coefs[5][12] = -238.21875f * temp * temp * param_leg7 * param_leg7ret;

			coefs[7][12] = 147.46875f * temp * temp * temp * param_leg7 * param_leg7ret;



            };



if (gval.leg8 != 0xFF) { 



                        param_leg8 = ((float)gval.leg8 / 254.0f); 

			temp = param_leg8 * param_leg8;

			coefs[0][13] = 10.1171875f * param_leg8ret;

			coefs[2][13] = -324.84375f * temp * param_leg8ret;

			coefs[4][13] = 1786.640625f * temp * temp * param_leg8ret;

			coefs[6][13] = -2721.46875f * temp * temp * temp * param_leg8ret;

			coefs[8][13] = 1457.9296875f * temp * temp * temp * temp * param_leg8ret;



            };



if (gval.leg2ret != 0xFF) { 



                        param_leg2ret = ((float)gval.leg2ret / 254.0f); 

			coefs[0][7] = -0.5f * param_leg2ret;

			coefs[2][7] = 1.5f * param_leg2 * param_leg2 * param_leg2ret;

            };



if (gval.leg3ret != 0xFF) { 



                        param_leg3ret = ((float)gval.leg3ret / 254.0f); 

			coefs[1][8] = -3.0f * param_leg3 * param_leg3ret;

			coefs[3][8] = 2.5f * param_leg3 * param_leg3 * param_leg3 * param_leg3ret;



            };



if (gval.leg4ret != 0xFF) { 



                        param_leg4ret = ((float)gval.leg4ret / 254.0f); 

			temp = param_leg4 * param_leg4;

			coefs[0][9] = 0.375f * param_leg4ret;

			coefs[2][9] = -3.75f * temp * param_leg4ret;

			coefs[4][9] = 4.375f * temp * temp * param_leg4ret;



            };



if (gval.leg5ret != 0xFF) { 



                        param_leg5 = ((float)gval.leg5ret / 254.0f); 

			temp = param_leg5 * param_leg5;

			coefs[1][10] = 1.875f * param_leg5 * param_leg5ret;

			coefs[3][10] = -8.75f * temp * param_leg5 * param_leg5ret;

			coefs[5][10] = 7.875f * temp * temp * param_leg5 * param_leg5ret;



            };



if (gval.leg6ret != 0xFF) { 



                        param_leg6ret = ((float)gval.leg6ret / 254.0f); 

			temp = param_leg6 * param_leg6;

			coefs[0][11] = 0.3125f * param_leg6ret;

			coefs[2][11] = 6.5625f * temp * param_leg6ret;

			coefs[4][11] = -19.6875f * temp * temp * param_leg6ret;

			coefs[6][11] = 14.4375f * temp * temp * temp * param_leg6ret;



            };



if (gval.leg7ret != 0xFF) { 



                        param_leg7ret = ((float)gval.leg7ret / 254.0f); 

			temp = param_leg7 * param_leg7;

			coefs[0][12] = 15.3125f * param_leg7ret;

			coefs[3][12] = 127.96875f * temp * param_leg7 * param_leg7ret;

			coefs[5][12] = -238.21875f * temp * temp * param_leg7 * param_leg7ret;

			coefs[7][12] = 147.46875f * temp * temp * temp * param_leg7 * param_leg7ret;



            };



if (gval.leg8ret != 0xFF) { 



                        param_leg8ret = ((float)gval.leg8ret / 254.0f); 

			temp = param_leg8 * param_leg8;

			coefs[0][13] = 10.1171875f * param_leg8ret;

			coefs[2][13] = -324.84375f * temp * param_leg8ret;

			coefs[4][13] = 1786.640625f * temp * temp * param_leg8ret;

			coefs[6][13] = -2721.46875f * temp * temp * temp * param_leg8ret;

			coefs[8][13] = 1457.9296875f * temp * temp * temp * temp * param_leg8ret;



            };



if (gval.dry != 0xFF) { 



                        param_dry = ((float)gval.dry / 254.0f); 



            };



if (gval.wet != 0xFF) { 



                        param_wet = ((float)gval.wet / 254.0f); 



            };



if (gval.ingain != 0xFF) { 



                        param_ingain = ((float)gval.ingain / 127.0f); 



            };



if (gval.inclip != 0xFF) { 



                        param_inclip = ((int)gval.inclip); 



            };



if (gval.outclip != 0xFF) { 



                        param_outclip = ((int)gval.outclip); 



            };










}




bool mi::MDKWork(float *psamples, int numsamples, int const mode)

{

            return false;

}



bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode)

{

            if (mode==WM_WRITE)

                        return false;

            if (mode==WM_NOIO)

                        return false;

            if (mode==WM_READ)                        // <thru>

                        return true;



            float inL, inR, outL, outR, xL, xR, xL2, xR2, xL4, xR4;
	int            i;

			float on;
int madeanoise = 0;

			on = param_dry + param_cheb2ret + param_cheb3ret + param_cheb4ret + param_cheb5ret + param_cheb6ret + param_cheb7ret + param_cheb8ret + param_leg2ret + param_leg3ret + param_leg4ret + param_leg5ret + param_leg6ret + param_leg7ret + param_leg8ret;

			if(on){
            for( i=0; i<numsamples*2; i++ ) {



                        inL = psamples[i] * param_ingain;

                        inR = psamples[i+1] * param_ingain;





			xL = inL * 0.000030517578125f; // = 1/32768

			xR = inR * 0.000030517578125f;

			if(xL > 1.0f) xL = 1.0f; //hardclip input (always)
			if(xL < -1.0f) xL = -1.0f;
			
			if(xR > 1.0f) xR = 1.0f;
			if(xR < -1.0f) xR = -1.0f;


	if(param_inclip > 0) { //softclipper
	xL = (xL * (1.5f - (0.5f * xL * xL)));
	xR = (xR * (1.5f - (0.5f * xR * xR)));
	}

			xL2 = (xL * xL) + tiny;


			xL4 = (xL2 * xL2) + tiny;

			xR2 = (xR * xR) + tiny;

			xR4 = (xR2 * xR2) + tiny;



                        outL = 0.0f;

                        outR = 0.0f;





if (param_cheb2ret != 0){

if(param_cheb2 != 0) {

outL += ((xL2 * coefs[2][0]) + coefs[0][0]);

outR += ((xR2 * coefs[2][0]) + coefs[0][0]);



}

}



if (param_cheb3ret != 0){

if(param_cheb3 != 0) {

outL += (xL * ((coefs[1][1]) + (xL2 * coefs[3][1])));

outR += (xR * ((coefs[1][1]) + (xR2 * coefs[3][1])));

}

}



if (param_cheb4ret != 0){

if(param_cheb4 != 0) {

outL += (coefs[0][2] + (xL2 * coefs[2][2]) + (xL4 * coefs[4][2]));

outR += (coefs[0][2] + (xR2 * coefs[2][2]) + (xR4 * coefs[4][2]));

}

}



if (param_cheb5ret != 0){

if(param_cheb5 != 0) {

outL += xL * ((coefs[1][3]) + (xL2 * coefs[3][3]) + (xL4 * coefs[5][3]));

outR += xR * ((coefs[1][3]) + (xR2 * coefs[3][3]) + (xR4 * coefs[5][3]));

}

}



if (param_cheb6ret != 0){

if(param_cheb6 != 0) {

outL += (coefs[0][4] + (xL2 * ((coefs[2][4]) + (xL2 * coefs[4][4]) + (xL4 * coefs[6][4]))));

outR += (coefs[0][4] + (xR2 * ((coefs[2][4]) + (xR2 * coefs[4][4]) + (xL4 * coefs[6][4]))));

}

}



if (param_cheb7ret != 0){

if(param_cheb7 != 0) {

outL += xL * ((coefs[1][5]) + (xL2 * coefs[3][5]) + (xL4 * ((coefs[5][5]) + (xL2 * coefs[7][5]))));

outR += xR * ((coefs[1][5]) + (xR2 * coefs[3][5]) + (xR4 * ((coefs[5][5]) + (xR2 * coefs[7][5]))));

}

}



if (param_cheb8ret != 0){

if(param_cheb8 != 0) {

outL += (coefs[0][6] + (xL2 * ((coefs[2][6]) + (xL2 * coefs[4][6]) + (xL4 * ((coefs[6][6]) + (xL2 * coefs[8][6]))))));

outR += (coefs[0][6] + (xR2 * ((coefs[2][6]) + (xR2 * coefs[4][6]) + (xR4 * ((coefs[6][6]) + (xR2 * coefs[8][6]))))));

}

}



if (param_leg2ret != 0){

if(param_leg2 != 0) {

outL += (coefs[0][7] + (xL2 * coefs[2][7]));

outR += (coefs[0][7] + (xR2 * coefs[2][7]));

}

}



if (param_leg3ret != 0){

if(param_leg3 != 0) {

outL += (xL * ((coefs[1][8]) + (xL2 * coefs[3][8])));

outR += (xR * ((coefs[1][8]) + (xR2 * coefs[3][8])));

}

}



if (param_leg4ret != 0){

if(param_leg4 != 0) {

outL += (coefs[0][9] + (xL2 * ((coefs[2][9]) + (xL2 * coefs[4][9]))));

outR += (coefs[0][9] + (xR2 * ((coefs[2][9]) + (xR2 * coefs[4][9]))));

}

}



if (param_leg5ret != 0){

if(param_leg5 != 0) {

outL += xL * ((coefs[1][10]) + (xL2 * ((coefs[3][10]) + (xL2 * coefs[5][10]))));

outR += xR * ((coefs[1][10]) + (xR2 * ((coefs[3][10]) + (xR2 * coefs[5][10]))));

}

}



if (param_leg6ret != 0){

if(param_leg6 != 0) {

outL += (coefs[0][11] + (xL2 * ((coefs[2][11]) + (xL2 * ((coefs[4][11]) + (xL2 * coefs[6][11]))))));

outR += (coefs[0][11] + (xR2 * ((coefs[2][11]) + (xR2 * ((coefs[4][11]) + (xR2 * coefs[6][11]))))));

}

}



if (param_leg7ret != 0){

if(param_leg7 != 0) {

outL += (coefs[0][12] + (xL * ((xL2 * coefs[3][12]) + (xL4 * ((coefs[5][12]) + (xL2 * coefs[7][12]))))));

outR += (coefs[0][12] + (xR * ((xR2 * coefs[3][12]) + (xR4 * ((coefs[5][12]) + (xR2 * coefs[7][12]))))));

}

}



if (param_leg8ret != 0){

if(param_leg8 != 0) {

outL += (coefs[0][13] + (xL2 * ((coefs[2][13]) + (xL2 * coefs[4][13]) + (xL4 * ((coefs[6][13]) + (xL2 * coefs[8][13]))))));

outR += (coefs[0][13] + (xR2 * ((coefs[2][13]) + (xR2 * coefs[4][13]) + (xR4 * ((coefs[6][13]) + (xR2 * coefs[8][13]))))));

}

}

outL = outL * (param_wet);
outR = outR * (param_wet);


if (param_dry > 0) {outL += (xL * param_dry);                      
					outR += (xR * param_dry);}                      

//hardclip output, always

if(outL > 1.0f) outL = 1.0f;
if(outL < -1.0f) outL = -1.0f;
if(outR > 1.0f) outR = 1.0f;
if(outR < -1.0f) outR = -1.0f;

if(param_outclip > 0) { //softclipper
	outL = (outL * (1.5f - (0.5f * outL * outL)));
	outR = (outR * (1.5f - (0.5f * outR * outR)));
}

outL = outL * 32768.0f;
outR = outR * 32768.0f;

//DC filter

dcspeedL = dcspeedL + (outL - dcposL) * 0.000004567f;
dcposL = dcposL + dcspeedL;
dcspeedL = dcspeedL * 0.96f;
outL = (outL - dcposL);

dcspeedR = dcspeedR + (outR - dcposR) * 0.000004567f;
dcposR = dcposR + dcspeedR;
dcspeedR = dcspeedR * 0.96f;
outR = (outR - dcposR);


if(outL != 0) madeanoise = 1;
if(outR != 0) madeanoise = 1;

						psamples[i] = outL;
						i++;

                        psamples[i] = outR;

            };


	if(madeanoise) {return true;}
	else{return false;} //because all of the samples were 0, switch the machine off

}else{ 		//i.e. if on=0; this is from the if statement right at the start
	return false;
} //end else

} //end Work function



void mi::Command(int const i)

{

            switch (i)

            {

            case 0:

                        MessageBox(NULL,"Edsca Migraine\n\n(c) Edward Earl, Oct 2001\nThanks: Rymix, Cyanphase\nmachine@emaajne.freeserve.co.uk\n\n","About Migraine",MB_OK|MB_SYSTEMMODAL);

                        break;

            default:

                        break;

            }

}

char const *mi::DescribeValue(int const param, int const value)

{

            static char txt[16];

            switch(param)		//!!!!!!!!! There MUST be a better way of doing this

            {

 case 0:	//Ingain

                        sprintf(txt,"%.1f%%", (((float)value / 127.0f) * 100.0f) );

                        return txt;

                        break;

case 1:		//Inclip

                        
			return NULL;		//!!!!!!!! Please work

                        break;

case 2:		//Cheb2 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 3:		//Cheb2 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 4:		//Cheb3 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 5:		//Cheb3 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 6:		//Cheb4 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 7:		//Cheb4 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 8:		//Cheb5 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 9:		//Cheb5 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 10:		//Cheb6 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 11:		//Cheb6 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 12:		//Cheb7 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 13:		//Cheb7 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 14:		//Cheb8 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 15:		//Cheb8 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 16:		//Leg2 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 17:		//Leg2 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 18:		//Leg3 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 19:		//Leg3 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 20:		//Leg4 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 21:		//Leg4 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 22:		//Leg5 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 23:		//Leg5 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 24:		//Leg6 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 25:		//Leg6 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 26:		//Leg7 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 27:		//Leg7 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 28:		//Leg8 amount

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f));

                        return txt;

                        break;

case 29:		//Leg8 ret

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 30:		//Dry out

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 31:		//Wet out

                        sprintf(txt,"%.1f%%", ((float)value / 254.0f * 100.0f) );

                        return txt;

                        break;

case 32:		//Outclip

 			return NULL;

                        break;



default:

                        return NULL;

            }

}



#pragma optimize ("", on) 



DLL_EXPORTS

